@extends('frontend.layouts.app')
@push('style')
<style>
    .header-style-two {
        background: rgba(40, 60, 71, 0.40);
    }
</style>
@endpush
@section('content')
<section class="popular">
    <div class="container">
        <div class="row justify-content-center mb-4">
            <div class="col-lg-6">
                <x-title :title="__('title.destination')" :desc="__('title.destination-desc')" />
            </div>
        </div>
        <div class="row">
            @forelse ($destinations as $destination)
                <x-frontend.home.destination :destination="$destination"/>
            @empty
                <div class="col-lg-12">
                    <div class="alert alert-danger text-center" role="alert">
                        @lang('app.no-destination-found')
                    </div>
                </div>
            @endforelse
        </div>
        <div class="row d-flex justify-content-center">
            {{ $destinations->links() }}
        </div>
    </div>
</section>
@endsection
